<?php

namespace App\Http\Controllers;

use App\MaquetteMilda;
use Illuminate\Http\Request;
use PDFN;
use QrCode;

class MaquetteMildaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('index');
    }

    public function generayeMaquetteMilda(Request $request)
    {
        $uniqueId = strtoupper(uniqid('CERT-'));
        $data = [
            'district' => $request->input('district'),
            'prefix' => $request->input('prefix'),
            'nb_carte1' => $request->input('nb_carte1'),
            'nb_carte2' => $request->input('nb_carte2'),
        ];

        $pdf = PDFN::loadView('maquette-milda', $data, [], [
            // 'format' => 'A4-L', // A4 Landscape
            'format' => 'A4',
            // 'format' => [210, 197], // Custom landscape size in mm
            // 'orientation' => 'L', // Landscape
            'margin_top'    => 0,
            'margin_right'  => 0,
            'margin_bottom' => 0,
            'margin_left'   => 0,
        ]);

        // return $pdf->download("certificate_{$user->name}.pdf");
        return $pdf->stream("certificate.pdf");
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\MaquetteMilda  $maquetteMilda
     * @return \Illuminate\Http\Response
     */
    public function show(MaquetteMilda $maquetteMilda)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\MaquetteMilda  $maquetteMilda
     * @return \Illuminate\Http\Response
     */
    public function edit(MaquetteMilda $maquetteMilda)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\MaquetteMilda  $maquetteMilda
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MaquetteMilda $maquetteMilda)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\MaquetteMilda  $maquetteMilda
     * @return \Illuminate\Http\Response
     */
    public function destroy(MaquetteMilda $maquetteMilda)
    {
        //
    }
}
